/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.model;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.entity.NPCRendererHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Slot;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.client.gui.model.GuiCreationScreenInterface;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.containers.ContainerLayer;
import noppes.npcs.entity.EntityNPC64x32;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityNpcAlex;
import noppes.npcs.entity.EntityNpcClassicPlayer;

public class GuiCreationEntities
extends GuiCreationScreenInterface
implements ICustomScrollListener {
    public HashMap<String, Class<? extends EntityLivingBase>> data = new HashMap();
    private final List<String> list;
    private boolean resetToSelected = true;
    private GuiCustomScroll scroll;

    public GuiCreationEntities(EntityNPCInterface npc, ContainerLayer container) {
        super(npc, container);
        for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
            String name = ent.getName();
            Class c = ent.getEntityClass();
            try {
                if (!EntityLiving.class.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers()) || !(Minecraft.func_71410_x().func_175598_ae().func_78715_a(c) instanceof RenderLivingBase) || name.toLowerCase().contains("customnpc")) continue;
                this.data.put(name, c.asSubclass(EntityLivingBase.class));
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        this.data.put("NPC 64x32", EntityNPC64x32.class);
        this.data.put("NPC Alex Arms", EntityNpcAlex.class);
        this.data.put("NPC Classic Player", EntityNpcClassicPlayer.class);
        this.list = new ArrayList<String>(this.data.keySet());
        this.list.add("NPC");
        this.list.sort(String.CASE_INSENSITIVE_ORDER);
        this.active = 1;
        this.xOffset = 60;
    }

    @Override
    protected void func_146284_a(@Nonnull GuiButton btn) {
        super.func_146284_a(btn);
        if (btn.field_146127_k == 10) {
            this.playerdata.setEntityClass(null);
            this.resetToSelected = true;
            this.npc.display.setSkinTexture("customnpcs:textures/entity/humanmale/steve.png");
            this.npc.reset();
            this.npc.display.width = this.npc.baseWidth;
            this.npc.display.height = this.npc.baseHeight;
            this.func_73866_w_();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!CustomNpcs.ShowDescriptions) {
            return;
        }
        if (this.getButton(1) != null && this.getButton(1).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.part.entity", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(2) != null && this.getButton(2).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.extra", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(4) != null && this.getButton(4).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.part.save", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(5) != null && this.getButton(5).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.part.load", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(10) != null && this.getButton(10).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.part.reset", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(66) != null && this.getButton(66).isHovered()) {
            this.setHoverText(new TextComponentTranslation("hover.back", new Object[0]).func_150254_d(), new Object[0]);
        } else {
            for (GuiButton b : this.field_146292_n) {
                if (b == null || !b.func_146115_a() || b.field_146127_k != 500) continue;
                this.setHoverText(new TextComponentTranslation("display.hover.part.rotate", new Object[0]).func_150254_d(), new Object[0]);
            }
        }
        this.drawHoverText(null, new Object[0]);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setListNotSorted(this.list);
        }
        this.scroll.guiLeft = this.field_147003_i;
        this.scroll.guiTop = this.field_147009_r + 68;
        this.scroll.setSize(100, this.field_147000_g - 96);
        String selected = "NPC";
        if (this.entity != null) {
            for (Map.Entry<String, Class<? extends EntityLivingBase>> en : this.data.entrySet()) {
                if (!en.getValue().toString().equals(this.entity.getClass().toString())) continue;
                selected = en.getKey();
            }
        }
        this.addButton(new GuiNpcButton(10, this.field_147003_i, this.field_147009_r + 46, 120, 20, "Reset To NPC"));
        this.getButton(10).setIsVisible(!selected.equals("NPC"));
        this.scroll.setSelected(selected);
        if (this.resetToSelected) {
            this.scroll.scrollTo(this.scroll.getSelected());
            this.resetToSelected = false;
        }
        this.addScroll(this.scroll);
        for (Slot slot : this.field_147002_h.field_75151_b) {
            slot.field_75223_e = -5000;
            slot.field_75221_f = -5000;
        }
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        this.playerdata.setEntityClass(this.data.get(scroll.getSelected()));
        EntityLivingBase entity = this.playerdata.getEntity(this.npc);
        if (entity != null) {
            RenderLivingBase render = (RenderLivingBase)this.field_146297_k.func_175598_ae().func_78715_a(entity.getClass());
            if (!NPCRendererHelper.getTexture((RenderLivingBase<EntityLivingBase>)render, entity).equals(TextureMap.field_174945_f.toString())) {
                this.npc.display.setSkinTexture(NPCRendererHelper.getTexture((RenderLivingBase<EntityLivingBase>)render, entity));
            }
        } else {
            this.npc.display.setSkinTexture("customnpcs:textures/entity/humanmale/steve.png");
        }
        this.npc.reset();
        this.npc.display.width = this.npc.baseWidth;
        this.npc.display.height = this.npc.baseHeight;
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
    }
}

